#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Codevember #25 Random Spiral 5Mod01.fsh  by  Etidou   
//https://www.shadertoy.com/view/Ds2Xzm
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

uniform vec2 u_resolution;

uniform float u_time;

float SEGMENT_TIME = 4.0;

const float PI = 3.1415926535;

#ifndef TAU
#define TAU 6.2831853071795864769252867665590
#endif

float segmentAngle;

float polySDFScale(vec2 uv, vec2 s, int V) {
    uv = uv*2.-1.;
    float a = atan(uv.x,uv.y)+PI;
    float r = length(uv);
    float v = TAU/float(V);
    float final = cos(floor(.3+a/v)*v-a)*r;
    return final;
}

vec2 rotate(vec2 st, float a) {
    st = mat2(cos(a),-sin(a),
              sin(a),cos(a))*(st-.5);
    return st+.5;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{  
    vec2 uv = (gl_FragCoord.xy - iResolution.xy * .5) / iResolution.yy + 0.5;

    vec2 rot = rotate(uv, PI + (u_time * 0.075));
    uv = rot;    
    
    float radius = length(uv - 0.5);

    float poly = polySDFScale(
        uv,
        vec2(2.7),
        8
    ); 

    float segmentAngle = ((PI + 40.0) / SEGMENT_TIME);

    poly -= segmentAngle + floor((cos(iTime) + poly) - segmentAngle);

    poly = min(-poly, segmentAngle * poly);

    vec2 st = vec2(sin((cos(-poly / -iTime), sin(poly + iTime)) + radius * segmentAngle))  ;

    st = max(min(st, 3.0 * st), st);

    vec3 color = vec3(0.0, cos(sin(-iTime) / -st));

    float len = length(uv - 0.5);

    color.r += sin(len * 40.0 + poly * 4.0 * sin((iTime / 5.0)));
    color.g = cos(len / 30.0 + poly * 6.0 * -sin((iTime / 5.0)));
    color.b *= sin(len * 5.0 + poly * 5.0 * cos(iTime / 5.0));

    fragColor = vec4(color, 1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

